﻿//*********************************************************
//
// Copyright (c) Microsoft. All rights reserved.
// THIS CODE IS PROVIDED *AS IS* WITHOUT WARRANTY OF
// ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING ANY
// IMPLIED WARRANTIES OF FITNESS FOR A PARTICULAR
// PURPOSE, MERCHANTABILITY, OR NON-INFRINGEMENT.
//
//*********************************************************

using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Navigation;
using SDKTemplate;
using System;

using System.Linq;
using System.Collections.Generic;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.Graphics.Display;
using Windows.UI.ViewManagement;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Core;
using Windows.Storage.Pickers;
using Windows.Storage;
using Windows.Storage.Streams;
using Windows.UI.Xaml.Media.Imaging;
using Windows.System.UserProfile;

namespace AccountPictureName
{
    public sealed partial class SetAccountPictureAndListen : SDKTemplate.Common.LayoutAwarePage
    {
        // A pointer back to the main page.  This is needed if you want to call methods in MainPage such
        // as NotifyUser()
        MainPage rootPage = MainPage.Current;

        public SetAccountPictureAndListen()
        {
            InitializeComponent();
        }

        /// <summary>
        /// Invoked when this page is about to be displayed in a Frame.
        /// </summary>
        /// <param name="e">Event data that describes how this page was reached.  The Parameter
        /// property is typically used to configure the page.</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            //Listen to AccountPictureChanged event
            UserInformation.AccountPictureChanged += this.PictureChanged;
        }

        protected override void OnNavigatedFrom(NavigationEventArgs e)
        {
            //Remove listener to AccountPictureChanged event
            UserInformation.AccountPictureChanged -= this.PictureChanged;
        }

        private async void SetImage_Click(object sender, RoutedEventArgs e)
        {
            
            FileOpenPicker imagePicker = new FileOpenPicker
            {
                ViewMode = PickerViewMode.Thumbnail,
                SuggestedStartLocation = PickerLocationId.PicturesLibrary,
                FileTypeFilter = { ".jpg", ".jpeg", ".png", ".bmp" }
            };

            StorageFile imageFile = await imagePicker.PickSingleFileAsync();
            if (imageFile != null)
            {
                // SetAccountPictureAsync() accepts 3 storageFile objects for setting the small image, large image, and video.
                // More than one type can be set in the same call, but a small image must be accompanied by a large image and/or video.
                // If only a large image is passed, the small image will be autogenerated.
                // If only a video is passed, the large image and small will be autogenerated.
                // Videos must be convertable to mp4, <=5MB, and height and width >= 448 pixels.

                // Setting the Account Picture will fail if user disallows it in PC Settings.
                SetAccountPictureResult result = await UserInformation.SetAccountPicturesAsync(null, imageFile, null);
                if (result == SetAccountPictureResult.Success)
                {
                    rootPage.NotifyUser("Account picture was successfully changed.", NotifyType.StatusMessage);
                }
                else
                {
                    rootPage.NotifyUser("Account picture could not be changed.", NotifyType.StatusMessage);
                    accountPic.Visibility = Visibility.Collapsed;
                }
            }
        }

        private async void SetVideo_Click(object sender, RoutedEventArgs e)
        {
            FileOpenPicker videoPicker = new FileOpenPicker
            {
                ViewMode = PickerViewMode.Thumbnail,
                SuggestedStartLocation = PickerLocationId.VideosLibrary,
                FileTypeFilter = { ".mp4", ".mpeg", ".wmv", ".mov" }
            };

            StorageFile videoFile = await videoPicker.PickSingleFileAsync();
            if (videoFile != null)
            {
                // SetAccountPictureAsync() accepts 3 storageFile objects for setting the small image, large image, and video.
                // More than one type can be set in the same call, but small image must be accompanied by a large image and/or video.
                // If only a large image is passed, the small image will be autogenerated.
                // If only a video is passed, the large image and small will be autogenerated.
                // Videos must be convertable to mp4, <=5MB, and height and width >= 448 pixels.

                // Setting the Account Picture will fail if a user disallows it in PC Settings.
                SetAccountPictureResult result = await UserInformation.SetAccountPicturesAsync(null, null, videoFile);
                if (result == SetAccountPictureResult.Success)
                {
                    rootPage.NotifyUser("Video account picture was successfully changed.", NotifyType.StatusMessage);
                }
                else
                {
                    rootPage.NotifyUser("Account picture could not be changed.", NotifyType.StatusMessage);
                    accountPic.Visibility = Visibility.Collapsed;
                }
            }
        }

        private async void PictureChanged(object sender, object e)
        {
            // The large picture returned by GetAccountPicture() is 448x448 pixels in size.
            StorageFile image = UserInformation.GetAccountPicture(AccountPictureKind.LargeImage) as StorageFile;
            if (image != null)
            {
                try
                {
                    IRandomAccessStream imageStream = await image.OpenReadAsync();
                    await Dispatcher.RunAsync(CoreDispatcherPriority.Normal, () =>
                    {
                        BitmapImage bitmapImage = new BitmapImage();
                        bitmapImage.SetSource(imageStream);
                        rootPage.NotifyUser("LargeImage path = " + image.Path, NotifyType.StatusMessage);
                        accountPic.Source = bitmapImage;
                        accountPic.Visibility = Visibility.Visible;
                    });
                }
                catch (Exception ex)
                {
                    rootPage.NotifyUser("Error opening stream: " + ex.ToString(), NotifyType.ErrorMessage);
                }
            }
            else
            {
                await this.Dispatcher.RunAsync(CoreDispatcherPriority.Normal, () =>
                {
                    rootPage.NotifyUser("Large Account Picture is not available", NotifyType.StatusMessage);
                });
            }
        }
    }
}
